<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>RDC Media</title>
    <link rel="icon" href="{{asset('assets/img/RDC-MEDIA-Logo.png')}}" type="image/x-icon">

    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">


    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>


    <script src="{{ asset('assets/js/script.js') }}"></script>


    <script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
</head>
<body>

    <header class="header">
        <div class="hamburger" id="burger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
        </div>

        <div class="header-logo">
            <div class="img">
                <a href="{{ route('home') }}"><img src="{{ asset('assets/img/RDC-MEDIA-Logo.png') }}" alt="logo"></a>
            </div>
        </div>

        <div class="user d-flex justyfy-content-between align-items-center gap-3 ms-auto">
            <div class="icon">
                <i class="fa fa-envelope" aria-hidden="true"><span class="badge text-white bg-danger">10</span></i>
            </div>

            <div class="user-img ms-1">
                <img src="{{ asset('assets/img/user-img.png') }}" alt="user Profile">
                <div class="mobile-dropdown">
                    <ul class="menu">
                        <li>
                           
                            <a  href="{{ route('logout') }}"
                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        {{ __('Logout') }}
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                        
                        
                        </li>
                        <!-- <li><a href="#">Another Action</a></li>
                        <li><a href="#">Some Else here</a></li> -->
                    </ul>
                </div>
            </div>

            <div class="dropdown">
                <a class="btn dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">{{ Auth::user()->name }}</a>

                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                    <li>
                    <a  class="dropdown-item" href="{{ route('logout') }}"
                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        {{ __('Logout') }}
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                </li>


                    <!-- <li><a class="dropdown-item" href="#">Another action</a></li>
                    <li><a class="dropdown-item" href="#">Something else here</a></li> -->
                </ul>
            </div>
        </div>
    </header>

    @include('layouts.sidebar')

    @yield('content')



    @if (Session::has('message'))
    <script>
            var type = "{{ Session::get('alert-type', 'info') }}"
            switch (type) {
                case 'info':

                    toastr.options.timeOut = 2000;
                    toastr.info("{{ Session::get('message') }}");
                    break;
                case 'success':

                    toastr.options.timeOut = 2000;
                    toastr.success("{{ Session::get('message') }}");
        
                    break;
                case 'warning':

                    toastr.options.timeOut = 2000;
                    toastr.warning("{{ Session::get('message') }}");
        
                    break;
                case 'error':

                    toastr.options.timeOut = 2000
                    toastr.error("{{ Session::get('message') }}");
                    break;
            }
      
    </script>

  @endif

<script>
        // document.getElementById("confirmDelete").addEventListener("click", function() {
        //     $('#frm_confirmDelete').submit();
        // });
</script>



    {{--<div id="app">
        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="{{ route('home') }}">
    Laravel Projct
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
        <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <!-- Left Side Of Navbar -->
        <ul class="navbar-nav me-auto">

        </ul>

        <!-- Right Side Of Navbar -->
        <ul class="navbar-nav ms-auto">
            <!-- Authentication Links -->
            @guest
            @if (Route::has('login'))
            <li class="nav-item">
                <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
            </li>
            @endif

            @if (Route::has('register'))
            <li class="nav-item">
                <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
            </li>
            @endif
            @else


            @canany(['create-role', 'edit-role', 'delete-role'])
            <li><a class="nav-link" href="{{ route('roles.index') }}">Manage Roles</a></li>
            @endcanany
            
            @canany(['create-user', 'edit-user', 'delete-user'])
            <li><a class="nav-link" href="{{ route('users.index') }}">Manage Users</a></li>
            @endcanany



            @canany(['create-product', 'edit-product', 'delete-product'])
            <li><a class="nav-link" href="{{ route('products.index') }}">Manage Products</a></li>
            @endcanany

            @can(['view-product'])
            <li><a class="nav-link" href="{{ route('products.index') }}">View Products</a></li>
            @endcan


            @canany(['create-genre', 'edit-genre', 'delete-genre'])
            <li><a class="nav-link" href="{{ route('genre.index') }}">Manage Genre</a></li>
            @endcanany

            <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    {{ Auth::user()->name }}
                </a>

                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                    <a class="dropdown-item" href="{{ route('logout') }}"
                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        {{ __('Logout') }}
                    </a>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </div>
            </li>
            @endguest
        </ul>
    </div>
    </div>
    </nav>








    <main class="py-4">
        <div class="container">
            <div class="row justify-content-center mt-3">
                <div class="col-md-12">
                    @yield('content')
                </div>
            </div>
        </div>
    </main>


    </div>--}}
</body>

</html>